/*
 * Decompiled with CFR 0.152.
 */
package com.epam.indigo;

import com.epam.indigo.Hybridization;
import com.epam.indigo.Indigo;
import com.epam.indigo.IndigoException;
import com.epam.indigo.IndigoLib;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IndigoObject
implements Iterator<IndigoObject>,
Iterable<IndigoObject> {
    protected final Indigo dispatcher;
    protected final IndigoLib lib;
    public int self;
    private Object parent;

    public IndigoObject(Indigo dispatcher, int id) {
        this.dispatcher = dispatcher;
        this.self = id;
        this.lib = Indigo.getLibrary();
    }

    public IndigoObject(Indigo dispatcher, int id, Object parent) {
        this.dispatcher = dispatcher;
        this.self = id;
        this.parent = parent;
        this.lib = Indigo.getLibrary();
    }

    public Indigo getIndigo() {
        return this.dispatcher;
    }

    public void dispose() {
        if (this.self >= 0) {
            this.dispatcher.setSessionID();
            this.lib.indigoFree(this.self);
            this.self = -1;
        }
    }

    protected void finalize() throws Throwable {
        if (!this.dispatcher.sessionReleased()) {
            this.dispose();
        }
        super.finalize();
    }

    public IndigoObject clone() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoClone(this.self)));
    }

    public String molfile() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this.lib.indigoMolfile(this.self));
    }

    public String sequence(IndigoObject library) {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this.lib.indigoSequence(this.self, library.self));
    }

    public String fasta(IndigoObject library) {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this.lib.indigoFasta(this.self, library.self));
    }

    public String idt(IndigoObject library) {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this.lib.indigoIdt(this.self, library.self));
    }

    public String helm(IndigoObject library) {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this.lib.indigoHelm(this.self, library.self));
    }

    public String getOriginalFormat() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this.lib.indigoGetOriginalFormat(this.self));
    }

    public void saveMolfile(String filename) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoSaveMolfileToFile(this.self, filename));
    }

    public void saveSequenceToFile(String filename, IndigoObject library) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoSaveSequenceToFile(this.self, filename, library.self));
    }

    public void saveFastaToFile(String filename) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoSaveFastaToFile(this.self, filename));
    }

    public String cml() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this.lib.indigoCml(this.self));
    }

    public String json() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this.lib.indigoJson(this.self));
    }

    public void saveCml(String filename) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoSaveCmlToFile(this.self, filename));
    }

    public String cdxml() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this.lib.indigoCdxml(this.self));
    }

    public String b64cdx() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this.lib.indigoCdxBase64(this.self));
    }

    public void saveCdxml(String filename) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoSaveCdxmlToFile(this.self, filename));
    }

    public byte[] mdlct() {
        IndigoObject buf = this.dispatcher.writeBuffer();
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoSaveMDLCT(this.self, buf.self));
        return buf.toBuffer();
    }

    public void addReactant(IndigoObject molecule) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, molecule, this.lib.indigoAddReactant(this.self, molecule.self));
    }

    public void addProduct(IndigoObject molecule) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, molecule, this.lib.indigoAddProduct(this.self, molecule.self));
    }

    public void addCatalyst(IndigoObject molecule) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, molecule, this.lib.indigoAddCatalyst(this.self, molecule.self));
    }

    public int countReactants() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoCountReactants(this.self));
    }

    public int countProducts() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoCountProducts(this.self));
    }

    public int countCatalysts() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoCountCatalysts(this.self));
    }

    public int countMolecules() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoCountMolecules(this.self));
    }

    public IndigoObject iterateAttachmentPoints(int order) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoIterateAttachmentPoints(this.self, order)), this);
    }

    public IndigoObject iterateReactants() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoIterateReactants(this.self)), this);
    }

    public IndigoObject iterateProducts() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoIterateProducts(this.self)), this);
    }

    public IndigoObject iterateCatalysts() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoIterateCatalysts(this.self)), this);
    }

    public IndigoObject iterateMolecules() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoIterateMolecules(this.self)), this);
    }

    public String rxnfile() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this.lib.indigoRxnfile(this.self));
    }

    public void saveRxnfile(String filename) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoSaveRxnfileToFile(this.self, filename));
    }

    public void automap() {
        this.automap("");
    }

    public void automap(String mode) {
        if (mode == null) {
            mode = "";
        }
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoAutomap(this.self, mode));
    }

    public int atomMappingNumber(IndigoObject reaction_atom) {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, reaction_atom, this.lib.indigoGetAtomMappingNumber(this.self, reaction_atom.self));
    }

    public void setAtomMappingNumber(IndigoObject reaction_atom, int number) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, reaction_atom, this.lib.indigoSetAtomMappingNumber(this.self, reaction_atom.self, number));
    }

    public void clearAAM() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoClearAAM(this.self));
    }

    public void correctReactingCenters() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoCorrectReactingCenters(this.self));
    }

    public IndigoObject iterateAtoms() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoIterateAtoms(this.self)), this);
    }

    public IndigoObject iteratePseudoatoms() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoIteratePseudoatoms(this.self)), this);
    }

    public IndigoObject iterateRSites() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoIterateRSites(this.self)), this);
    }

    public IndigoObject iterateStereocenters() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoIterateStereocenters(this.self)), this);
    }

    public IndigoObject iterateAlleneCenters() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoIterateAlleneCenters(this.self)), this);
    }

    public IndigoObject iterateRGroups() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoIterateRGroups(this.self)), this);
    }

    public IndigoObject iterateRGroupFragments() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoIterateRGroupFragments(this.self)), this);
    }

    public int countRGroups() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoCountRGroups(this.self));
    }

    public int countAttachmentPoints() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoCountAttachmentPoints(this.self));
    }

    public boolean isPseudoatom() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoIsPseudoatom(this.self)) == 1;
    }

    public boolean isRSite() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoIsRSite(this.self)) == 1;
    }

    public IndigoObject setRSite(String name) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoSetRSite(this.self, name)), this);
    }

    public boolean isTemplateAtom() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoIsTemplateAtom(this.self)) == 1;
    }

    public int stereocenterType() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoStereocenterType(this.self));
    }

    public int stereocenterGroup() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoStereocenterGroup(this.self));
    }

    public int[] stereocenterPyramid() {
        this.dispatcher.setSessionID();
        Pointer ptr = Indigo.checkResultPointer(this, this.lib.indigoStereocenterPyramid(this.self));
        return ptr.getIntArray(0L, 4);
    }

    public void changeStereocenterType(int type) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoChangeStereocenterType(this.self, type));
    }

    public void setStereocenterGroup(int group) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoSetStereocenterGroup(this.self, group));
    }

    public int singleAllowedRGroup() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoSingleAllowedRGroup(this.self));
    }

    public String symbol() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this.lib.indigoSymbol(this.self));
    }

    public int degree() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoDegree(this.self));
    }

    public Integer charge() {
        IntByReference res = new IntByReference();
        this.dispatcher.setSessionID();
        if (Indigo.checkResult(this, this.lib.indigoGetCharge(this.self, res)) == 1) {
            return res.getValue();
        }
        return null;
    }

    public int reactingCenter(IndigoObject bond) {
        IntByReference res = new IntByReference();
        this.dispatcher.setSessionID();
        if (Indigo.checkResult(this, bond, this.lib.indigoGetReactingCenter(this.self, bond.self, res)) == 1) {
            return res.getValue();
        }
        throw new IndigoException(this, "reactingCenter(): unexpected result");
    }

    public void setReactingCenter(IndigoObject bond, int type) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, bond, this.lib.indigoSetReactingCenter(this.self, bond.self, type));
    }

    public Integer explicitValence() {
        IntByReference res = new IntByReference();
        this.dispatcher.setSessionID();
        if (Indigo.checkResult(this, this.lib.indigoGetExplicitValence(this.self, res)) == 1) {
            return res.getValue();
        }
        return null;
    }

    public Integer radicalElectrons() {
        IntByReference res = new IntByReference();
        this.dispatcher.setSessionID();
        if (Indigo.checkResult(this, this.lib.indigoGetRadicalElectrons(this.self, res)) == 1) {
            return res.getValue();
        }
        return null;
    }

    public Integer radical() {
        IntByReference res = new IntByReference();
        this.dispatcher.setSessionID();
        if (Indigo.checkResult(this, this.lib.indigoGetRadical(this.self, res)) == 1) {
            return res.getValue();
        }
        return null;
    }

    public int atomicNumber() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoAtomicNumber(this.self));
    }

    public int isotope() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoIsotope(this.self));
    }

    public int valence() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoValence(this.self));
    }

    public Hybridization getHybridization() {
        this.dispatcher.setSessionID();
        return Hybridization.fromNum(Indigo.checkResult(this, this.lib.indigoGetHybridization(this.self)));
    }

    public String getHybridizationStr() {
        return this.getHybridization().getStrVal();
    }

    public int checkValence() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoCheckValence(this.self));
    }

    public int checkQuery() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoCheckQuery(this.self));
    }

    public int checkRGroups() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoCheckRGroups(this.self));
    }

    public int checkChirality() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoCheckChirality(this.self));
    }

    public int check3DStereo() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoCheck3DStereo(this.self));
    }

    public int checkStereo() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoCheckStereo(this.self));
    }

    public String check() {
        String type = "";
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this.lib.indigoCheckObj(this.self, type));
    }

    public String check(String type) {
        if (type == null) {
            type = "";
        }
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this.lib.indigoCheckObj(this.self, type));
    }

    public Integer countHydrogens() {
        IntByReference res = new IntByReference();
        this.dispatcher.setSessionID();
        if (Indigo.checkResult(this, this.lib.indigoCountHydrogens(this.self, res)) == 1) {
            return res.getValue();
        }
        return null;
    }

    public int countImplicitHydrogens() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoCountImplicitHydrogens(this.self));
    }

    public void resetCharge() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoResetCharge(this.self));
    }

    public void resetExplicitValence() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoResetExplicitValence(this.self));
    }

    public void resetRadical() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoResetRadical(this.self));
    }

    public void resetIsotope() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoResetIsotope(this.self));
    }

    public void setAttachmentPoint(int order) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoSetAttachmentPoint(this.self, order));
    }

    public void clearAttachmentPoints() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoClearAttachmentPoints(this.self));
    }

    public void removeConstraints(String type) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoRemoveConstraints(this.self, type));
    }

    public void addConstraint(String type, String value) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoAddConstraint(this.self, type, value));
    }

    public void addConstraintNot(String type, String value) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoAddConstraintNot(this.self, type, value));
    }

    public void addConstraintOr(String type, String value) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoAddConstraintOr(this.self, type, value));
    }

    public void resetStereo() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoResetStereo(this.self));
    }

    public void invertStereo() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoInvertStereo(this.self));
    }

    public int countAtoms() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoCountAtoms(this.self));
    }

    public int countBonds() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoCountBonds(this.self));
    }

    public int countPseudoatoms() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoCountPseudoatoms(this.self));
    }

    public int countRSites() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoCountRSites(this.self));
    }

    public IndigoObject iterateBonds() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoIterateBonds(this.self)), this);
    }

    public int bondOrder() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoBondOrder(this.self));
    }

    public int bondStereo() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoBondStereo(this.self));
    }

    public int topology() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoTopology(this.self));
    }

    public IndigoObject iterateNeighbors() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoIterateNeighbors(this.self)), this);
    }

    public IndigoObject bond() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoBond(this.self)));
    }

    public IndigoObject getAtom(int idx) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoGetAtom(this.self, idx)), this);
    }

    public IndigoObject getMolecule(int idx) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoGetMolecule(this.self, idx)), this);
    }

    public IndigoObject getBond(int idx) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoGetBond(this.self, idx)), this);
    }

    public IndigoObject source() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoSource(this.self)));
    }

    public IndigoObject destination() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoDestination(this.self)));
    }

    public void clearCisTrans() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoClearCisTrans(this.self));
    }

    public void clearStereocenters() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoClearStereocenters(this.self));
    }

    public void clearAlleneCenters() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoClearAlleneCenters(this.self));
    }

    public int countStereocenters() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoCountStereocenters(this.self));
    }

    public int countAlleneCenters() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoCountAlleneCenters(this.self));
    }

    public int resetSymmetricCisTrans() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoResetSymmetricCisTrans(this.self));
    }

    public int resetSymmetricStereocenters() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoResetSymmetricStereocenters(this.self));
    }

    public int markEitherCisTrans() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoMarkEitherCisTrans(this.self));
    }

    public int markStereobonds() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoMarkStereobonds(this.self));
    }

    public int validateChirality() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoValidateChirality(this.self));
    }

    public IndigoObject addAtom(String symbol) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoAddAtom(this.self, symbol)), this);
    }

    public IndigoObject resetAtom(String symbol) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoResetAtom(this.self, symbol)), this);
    }

    public IndigoObject addRSite(String name) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoAddRSite(this.self, name)), this);
    }

    public void setCharge(int charge) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoSetCharge(this.self, charge));
    }

    public void setRadical(int radical) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoSetRadical(this.self, radical));
    }

    public void setExplicitValence(int valence) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoSetExplicitValence(this.self, valence));
    }

    public void setIsotope(int isotope) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoSetIsotope(this.self, isotope));
    }

    public void setImplicitHCount(int hcount) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoSetImplicitHCount(this.self, hcount));
    }

    public IndigoObject addBond(IndigoObject atom, int order) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoAddBond(this.self, atom.self, order)), atom);
    }

    public void setBondOrder(int order) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoSetBondOrder(this.self, order));
    }

    public IndigoObject merge(IndigoObject other) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, other, this.lib.indigoMerge(this.self, other.self)), this);
    }

    public void highlight() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoHighlight(this.self));
    }

    public void unhighlight() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoUnhighlight(this.self));
    }

    public boolean isHighlighted() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoIsHighlighted(this.self)) == 1;
    }

    public int countComponents() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoCountComponents(this.self));
    }

    public int componentIndex() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoComponentIndex(this.self));
    }

    public IndigoObject iterateComponents() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoIterateComponents(this.self)), this);
    }

    public IndigoObject component(int index) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoComponent(this.self, index)), this);
    }

    public int countSSSR() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoCountSSSR(this.self));
    }

    public IndigoObject iterateSSSR() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoIterateSSSR(this.self)), this);
    }

    public IndigoObject iterateSubtrees(int min_vertices, int max_vertices) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoIterateSubtrees(this.self, min_vertices, max_vertices)), this);
    }

    public IndigoObject iterateRings(int min_vertices, int max_vertices) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoIterateRings(this.self, min_vertices, max_vertices)), this);
    }

    public IndigoObject iterateEdgeSubmolecules(int min_edges, int max_edges) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoIterateEdgeSubmolecules(this.self, min_edges, max_edges)), this);
    }

    public int countHeavyAtoms() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoCountHeavyAtoms(this.self));
    }

    public String grossFormula() {
        int gf = -1;
        try {
            this.dispatcher.setSessionID();
            gf = Indigo.checkResult(this, this.lib.indigoGrossFormula(this.self));
            String string = Indigo.checkResultString(this, this.lib.indigoToString(gf));
            return string;
        }
        finally {
            this.lib.indigoFree(gf);
        }
    }

    public double molecularWeight() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultDouble(this, this.lib.indigoMolecularWeight(this.self));
    }

    public double mostAbundantMass() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultDouble(this, this.lib.indigoMostAbundantMass(this.self));
    }

    public double monoisotopicMass() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultDouble(this, this.lib.indigoMonoisotopicMass(this.self));
    }

    public String massComposition() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this.lib.indigoMassComposition(this.self));
    }

    public double tpsa() {
        return this.tpsa(false);
    }

    public double tpsa(boolean includeSP) {
        this.dispatcher.setSessionID();
        return Indigo.checkResultDouble(this, this.lib.indigoTPSA(this.self, includeSP));
    }

    public int numRotatableBonds() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoNumRotatableBonds(this.self));
    }

    public int numHydrogenBondAcceptors() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoNumHydrogenBondAcceptors(this.self));
    }

    public int numHydrogenBondDonors() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoNumHydrogenBondDonors(this.self));
    }

    public double logP() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultDouble(this, this.lib.indigoLogP(this.self));
    }

    public double molarRefractivity() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultDouble(this, this.lib.indigoMolarRefractivity(this.self));
    }

    public double pKa() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultDouble(this, this.lib.indigoPka(this.self));
    }

    public String canonicalSmiles() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this.lib.indigoCanonicalSmiles(this.self));
    }

    public String layeredCode() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this.lib.indigoLayeredCode(this.self));
    }

    public long hash() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultLong(this, this.lib.indigoHash(this.self));
    }

    public boolean hasCoord() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoHasCoord(this.self)) == 1;
    }

    public boolean hasZCoord() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoHasZCoord(this.self)) == 1;
    }

    public boolean isChiral() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoIsChiral(this.self)) == 1;
    }

    public boolean isPossibleFischerProjection(String options) {
        if (options == null) {
            options = "";
        }
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoIsPossibleFischerProjection(this.self, options)) == 1;
    }

    public float[] xyz() {
        this.dispatcher.setSessionID();
        Pointer ptr = Indigo.checkResultPointer(this, this.lib.indigoXYZ(this.self));
        return ptr.getFloatArray(0L, 3);
    }

    public void setXYZ(float x, float y, float z) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoSetXYZ(this.self, x, y, z));
    }

    public void setXYZ(float[] xyz) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoSetXYZ(this.self, xyz[0], xyz[1], xyz[2]));
    }

    public int countSuperatoms() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoCountSuperatoms(this.self));
    }

    public int countDataSGroups() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoCountDataSGroups(this.self));
    }

    public int countRepeatingUnits() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoCountRepeatingUnits(this.self));
    }

    public int countMultipleGroups() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoCountMultipleGroups(this.self));
    }

    public int countGenericSGroups() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoCountGenericSGroups(this.self));
    }

    public IndigoObject iterateSuperatoms() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoIterateSuperatoms(this.self)), this);
    }

    public IndigoObject iterateDataSGroups() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoIterateDataSGroups(this.self)), this);
    }

    public IndigoObject iterateRepeatingUnits() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoIterateRepeatingUnits(this.self)), this);
    }

    public IndigoObject iterateMultipleGroups() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoIterateMultipleGroups(this.self)), this);
    }

    public IndigoObject iterateGenericSGroups() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoIterateGenericSGroups(this.self)), this);
    }

    public IndigoObject iterateSGroups() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoIterateSGroups(this.self)), this);
    }

    public IndigoObject iterateTGroups() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoIterateTGroups(this.self)), this);
    }

    public IndigoObject getDataSGroup(int index) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoGetDataSGroup(this.self, index)), this);
    }

    public IndigoObject getSuperatom(int index) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoGetSuperatom(this.self, index)), this);
    }

    public IndigoObject getGenericSGroup(int index) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoGetGenericSGroup(this.self, index)), this);
    }

    public IndigoObject getMultipleGroup(int index) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoGetMultipleGroup(this.self, index)), this);
    }

    public IndigoObject getRepeatingUnit(int index) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoGetRepeatingUnit(this.self, index)), this);
    }

    public String description() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this.lib.indigoDescription(this.self));
    }

    public String data() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this.lib.indigoData(this.self));
    }

    public IndigoObject addDataSGroup(int[] atoms, int[] bonds, String description, String data) {
        if (description == null) {
            description = "";
        }
        if (data == null) {
            data = "";
        }
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoAddDataSGroup(this.self, atoms.length, atoms, bonds.length, bonds, description, data)), this);
    }

    public IndigoObject addDataSGroup(Collection<Integer> atoms, Collection<Integer> bonds, String description, String data) {
        return this.addDataSGroup(Indigo.toIntArray(atoms), Indigo.toIntArray(bonds), description, data);
    }

    public IndigoObject createSGroup(String type, IndigoObject mapping, String name) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoCreateSGroup(type, mapping.self, name)), this);
    }

    public String getSGroupClass() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this.lib.indigoGetSGroupClass(this.self));
    }

    public void setSGroupClass(String sgclass) {
        if (sgclass == null) {
            sgclass = "";
        }
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoSetSGroupClass(this.self, sgclass));
    }

    public String getSGroupName() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this.lib.indigoGetSGroupName(this.self));
    }

    public void setSGroupName(String sgname) {
        if (sgname == null) {
            sgname = "";
        }
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoSetSGroupName(this.self, sgname));
    }

    public int getSGroupNumCrossBonds() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoGetSGroupNumCrossBonds(this.self));
    }

    public int addSGroupAttachmentPoint(int aidx, int lvidx, String apid) {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoAddSGroupAttachmentPoint(this.self, aidx, lvidx, apid));
    }

    public int deleteSGroupAttachmentPoint(int apidx) {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoDeleteSGroupAttachmentPoint(this.self, apidx));
    }

    public int getSGroupDisplayOption() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoGetSGroupDisplayOption(this.self));
    }

    public int getSGroupSeqId() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoGetSGroupSeqId(this.self));
    }

    public float[] getSGroupCoords() {
        this.dispatcher.setSessionID();
        Pointer ptr = Indigo.checkResultPointer(this, this.lib.indigoGetSGroupCoords(this.self));
        return ptr.getFloatArray(0L, 2);
    }

    public int setSGroupDisplayOption(int option) {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoSetSGroupDisplayOption(this.self, option));
    }

    public String getRepeatingUnitSubscript() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this.lib.indigoGetRepeatingUnitSubscript(this.self));
    }

    public int getRepeatingUnitConnectivity() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoGetRepeatingUnitConnectivity(this.self));
    }

    public int getSGroupMultiplier() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoGetSGroupMultiplier(this.self));
    }

    public int setSGroupMultiplier(int mult) {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoSetSGroupMultiplier(this.self, mult));
    }

    public int setSGroupData(String data) {
        this.dispatcher.setSessionID();
        if (data == null) {
            data = "";
        }
        return Indigo.checkResult(this, this.lib.indigoSetSGroupData(this.self, data));
    }

    public int setSGroupCoords(float x, float y) {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoSetSGroupCoords(this.self, x, y));
    }

    public int setSGroupDescription(String description) {
        this.dispatcher.setSessionID();
        if (description == null) {
            description = "";
        }
        return Indigo.checkResult(this, this.lib.indigoSetSGroupDescription(this.self, description));
    }

    public int setSGroupFieldName(String name) {
        this.dispatcher.setSessionID();
        if (name == null) {
            name = "";
        }
        return Indigo.checkResult(this, this.lib.indigoSetSGroupFieldName(this.self, name));
    }

    public int setSGroupQueryCode(String querycode) {
        this.dispatcher.setSessionID();
        if (querycode == null) {
            querycode = "";
        }
        return Indigo.checkResult(this, this.lib.indigoSetSGroupQueryCode(this.self, querycode));
    }

    public int setSGroupQueryOper(String queryoper) {
        this.dispatcher.setSessionID();
        if (queryoper == null) {
            queryoper = "";
        }
        return Indigo.checkResult(this, this.lib.indigoSetSGroupQueryOper(this.self, queryoper));
    }

    public int setSGroupDisplay(String option) {
        this.dispatcher.setSessionID();
        if (option == null) {
            option = "";
        }
        return Indigo.checkResult(this, this.lib.indigoSetSGroupDisplay(this.self, option));
    }

    public int setSGroupLocation(String option) {
        this.dispatcher.setSessionID();
        if (option == null) {
            option = "";
        }
        return Indigo.checkResult(this, this.lib.indigoSetSGroupLocation(this.self, option));
    }

    public int setSGroupTag(String tag) {
        this.dispatcher.setSessionID();
        if (tag == null) {
            tag = "";
        }
        return Indigo.checkResult(this, this.lib.indigoSetSGroupTag(this.self, tag));
    }

    public int setSGroupTagAlign(int tag_align) {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoSetSGroupTagAlign(this.self, tag_align));
    }

    public int setSGroupDataType(String data_type) {
        if (data_type == null) {
            data_type = "";
        }
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoSetSGroupDataType(this.self, data_type));
    }

    public int setSGroupXCoord(float x) {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoSetSGroupXCoord(this.self, x));
    }

    public int setSGroupYCoord(float y) {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoSetSGroupYCoord(this.self, y));
    }

    public IndigoObject findSGroups(String property, String value) {
        if (property == null) {
            property = "";
        }
        if (value == null) {
            value = "";
        }
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoFindSGroups(this.self, property, value)), this);
    }

    public int getSGroupType() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoGetSGroupType(this.self));
    }

    public int getSGroupIndex() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoGetSGroupIndex(this.self));
    }

    public int getSGroupOriginalId() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoGetSGroupOriginalId(this.self));
    }

    public int setSGroupOriginalId(int original) {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoSetSGroupOriginalId(this.self, original));
    }

    public int getSGroupParentId() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoGetSGroupParentId(this.self));
    }

    public int setSGroupParentId(int parent) {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoSetSGroupParentId(this.self, parent));
    }

    public int addTemplate(IndigoObject templates, String name) {
        if (name == null) {
            name = "";
        }
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoAddTemplate(this.self, templates.self, name));
    }

    public int removeTemplate(String name) {
        if (name == null) {
            name = "";
        }
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoRemoveTemplate(this.self, name));
    }

    public int findTemplate(String name) {
        if (name == null) {
            name = "";
        }
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoFindTemplate(this.self, name));
    }

    public String getTGroupClass() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this.lib.indigoGetTGroupClass(this.self));
    }

    public String getTGroupName() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this.lib.indigoGetTGroupName(this.self));
    }

    public String getTGroupAlias() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this.lib.indigoGetTGroupAlias(this.self));
    }

    public int transformSCSRtoCTAB() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoTransformSCSRtoCTAB(this.self));
    }

    public int transformCTABtoSCSR(IndigoObject templates) {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoTransformCTABtoSCSR(this.self, templates.self));
    }

    public String getTemplateAtomClass() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this.lib.indigoGetTemplateAtomClass(this.self));
    }

    public int setTemplateAtomClass(String name) {
        if (name == null) {
            name = "";
        }
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoSetTemplateAtomClass(this.self, name));
    }

    public int setSGroupBrackets(int brk_style, float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoSetSGroupBrackets(this.self, brk_style, x1, y1, x2, y2, x3, y3, x4, y4));
    }

    public void setDataSGroupXY(float x, float y) {
        this.setDataSGroupXY(x, y, "");
    }

    public void setDataSGroupXY(float x, float y, String options) {
        this.dispatcher.setSessionID();
        if (options == null) {
            options = "";
        }
        Indigo.checkResult(this, this.lib.indigoSetDataSGroupXY(this.self, x, y, options));
    }

    public void addStereocenter(int type, int v1, int v2, int v3) {
        this.addStereocenter(type, v1, v2, v3, -1);
    }

    public void addStereocenter(int type, int v1, int v2, int v3, int v4) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoAddStereocenter(this.self, type, v1, v2, v3, v4));
    }

    public IndigoObject createSubmolecule(int[] vertices) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoCreateSubmolecule(this.self, vertices.length, vertices)));
    }

    public IndigoObject createSubmolecule(Collection<Integer> vertices) {
        return this.createSubmolecule(Indigo.toIntArray(vertices));
    }

    public IndigoObject getSubmolecule(int[] vertices) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoGetSubmolecule(this.self, vertices.length, vertices)));
    }

    public IndigoObject getSubmolecule(Collection<Integer> vertices) {
        return this.getSubmolecule(Indigo.toIntArray(vertices));
    }

    public IndigoObject createEdgeSubmolecule(int[] vertices, int[] edges) {
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoCreateEdgeSubmolecule(this.self, vertices.length, vertices, edges.length, edges)));
    }

    public IndigoObject createEdgeSubmolecule(Collection<Integer> vertices, Collection<Integer> edges) {
        return this.createEdgeSubmolecule(Indigo.toIntArray(vertices), Indigo.toIntArray(edges));
    }

    public void removeAtoms(int[] vertices) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoRemoveAtoms(this.self, vertices.length, vertices));
    }

    public void removeAtoms(Collection<Integer> vertices) {
        this.removeAtoms(Indigo.toIntArray(vertices));
    }

    public void removeBonds(int[] bonds) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoRemoveBonds(this.self, bonds.length, bonds));
    }

    public void removeBonds(Collection<Integer> bonds) {
        this.removeBonds(Indigo.toIntArray(bonds));
    }

    public float alignAtoms(int[] atom_ids, float[] desired_xyz) {
        if (atom_ids.length * 3 != desired_xyz.length) {
            throw new IndigoException(this, "desired_xyz[] must be exactly 3 times bigger than atom_ids[]");
        }
        this.dispatcher.setSessionID();
        return Indigo.checkResultFloat(this, this.lib.indigoAlignAtoms(this.self, atom_ids.length, atom_ids, desired_xyz));
    }

    public float alignAtoms(Collection<Integer> atom_ids, Collection<Float> desired_xyz) {
        return this.alignAtoms(Indigo.toIntArray(atom_ids), Indigo.toFloatArray(desired_xyz));
    }

    public void aromatize() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoAromatize(this.self));
    }

    public void dearomatize() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoDearomatize(this.self));
    }

    public void foldHydrogens() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoFoldHydrogens(this.self));
    }

    public void unfoldHydrogens() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoUnfoldHydrogens(this.self));
    }

    public void foldUnfoldHydrogens() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoFoldUnfoldHydrogens(this.self));
    }

    public void clearXYZ() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoClearXYZ(this.self));
    }

    public void layout() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoLayout(this.self));
    }

    public void clean2d() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoClean2d(this.self));
    }

    public String smiles() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this.lib.indigoSmiles(this.self));
    }

    public String smarts() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this.lib.indigoSmarts(this.self));
    }

    public String canonicalSmarts() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this.lib.indigoCanonicalSmarts(this.self));
    }

    public String name() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this.lib.indigoName(this.self));
    }

    public void setName(String name) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoSetName(this.self, name));
    }

    public byte[] serialize() {
        PointerByReference ptr = new PointerByReference();
        IntByReference size = new IntByReference();
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoSerialize(this.self, ptr, size));
        Pointer p = ptr.getValue();
        return p.getByteArray(0L, size.getValue());
    }

    public boolean hasProperty(String prop) {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoHasProperty(this.self, prop)) == 1;
    }

    public String getProperty(String prop) {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this.lib.indigoGetProperty(this.self, prop));
    }

    public void setProperty(String prop, String value) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoSetProperty(this.self, prop, value));
    }

    public void removeProperty(String prop) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoRemoveProperty(this.self, prop));
    }

    public IndigoObject iterateProperties() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoIterateProperties(this.self)), this);
    }

    public void clearProperties() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoClearProperties(this.self));
    }

    public String checkBadValence() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this.lib.indigoCheckBadValence(this.self));
    }

    public String checkAmbiguousH() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this.lib.indigoCheckAmbiguousH(this.self));
    }

    public IndigoObject fingerprint() {
        return this.fingerprint("");
    }

    public IndigoObject fingerprint(String type) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoFingerprint(this.self, type)));
    }

    public String oneBitsList() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this.lib.indigoOneBitsList(this.self));
    }

    public int countBits() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoCountBits(this.self));
    }

    public String rawData() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this.lib.indigoRawData(this.self));
    }

    public int tell() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoTell(this.self));
    }

    public void sdfAppend(IndigoObject item) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, item, this.lib.indigoSdfAppend(this.self, item.self));
    }

    public void smilesAppend(IndigoObject item) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, item, this.lib.indigoSmilesAppend(this.self, item.self));
    }

    public void rdfHeader() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoRdfHeader(this.self));
    }

    public void rdfAppend(IndigoObject item) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, item, this.lib.indigoRdfAppend(this.self, item.self));
    }

    public void cmlHeader() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoCmlHeader(this.self));
    }

    public void cmlAppend(IndigoObject item) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, item, this.lib.indigoCmlAppend(this.self, item.self));
    }

    public void cmlFooter() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoCmlFooter(this.self));
    }

    public IndigoObject iterateArray() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoIterateArray(this.self)), this);
    }

    public int count() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoCount(this.self));
    }

    public void clear() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoClear(this.self));
    }

    public int arrayAdd(IndigoObject other) {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, other, this.lib.indigoArrayAdd(this.self, other.self));
    }

    public IndigoObject at(int idx) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoAt(this.self, idx)), this);
    }

    public void ignoreAtom(IndigoObject atom) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, atom, this.lib.indigoIgnoreAtom(this.self, atom.self));
    }

    public void unignoreAtom(IndigoObject atom) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, atom, this.lib.indigoUnignoreAtom(this.self, atom.self));
    }

    public void unignoreAllAtoms() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoUnignoreAllAtoms(this.self));
    }

    public IndigoObject match(IndigoObject query) {
        this.dispatcher.setSessionID();
        int res = Indigo.checkResult(this, query, this.lib.indigoMatch(this.self, query.self));
        if (res == 0) {
            return null;
        }
        return new IndigoObject(this.dispatcher, res, this);
    }

    public int countMatches(IndigoObject query) {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, query, this.lib.indigoCountMatches(this.self, query.self));
    }

    public int countMatchesWithLimit(IndigoObject query, int embeddings_limit) {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, query, this.lib.indigoCountMatchesWithLimit(this.self, query.self, embeddings_limit));
    }

    public IndigoObject iterateMatches(IndigoObject query) {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, query, this.lib.indigoIterateMatches(this.self, query.self)), this);
    }

    public IndigoObject highlightedTarget() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoHighlightedTarget(this.self)));
    }

    public IndigoObject mapAtom(IndigoObject query_atom) {
        this.dispatcher.setSessionID();
        int res = Indigo.checkResult(this, query_atom, this.lib.indigoMapAtom(this.self, query_atom.self));
        if (res == 0) {
            return null;
        }
        return new IndigoObject(this.dispatcher, res, this);
    }

    public IndigoObject mapMolecule(IndigoObject query_reaction_molecule) {
        this.dispatcher.setSessionID();
        int res = Indigo.checkResult(this, query_reaction_molecule, this.lib.indigoMapMolecule(this.self, query_reaction_molecule.self));
        if (res == 0) {
            return null;
        }
        return new IndigoObject(this.dispatcher, res, this);
    }

    public IndigoObject mapBond(IndigoObject query_bond) {
        Object[] guard = new Object[]{this, query_bond};
        this.dispatcher.setSessionID();
        int res = Indigo.checkResult(this, query_bond, this.lib.indigoMapBond(this.self, query_bond.self));
        if (res == 0) {
            return null;
        }
        return new IndigoObject(this.dispatcher, res, this);
    }

    public IndigoObject allScaffolds() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoAllScaffolds(this.self)));
    }

    public IndigoObject decomposedMoleculeScaffold() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoDecomposedMoleculeScaffold(this.self)));
    }

    @Deprecated
    public IndigoObject iterateDecomposedMolecules() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoIterateDecomposedMolecules(this.self)), this);
    }

    public IndigoObject decomposedMoleculeHighlighted() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoDecomposedMoleculeHighlighted(this.self)));
    }

    public IndigoObject decomposedMoleculeWithRGroups() {
        this.dispatcher.setSessionID();
        return new IndigoObject(this.dispatcher, Indigo.checkResult(this, this.lib.indigoDecomposedMoleculeWithRGroups(this.self)));
    }

    public IndigoObject decomposeMolecule(IndigoObject mol) {
        this.dispatcher.setSessionID();
        int res = Indigo.checkResult(this, this.lib.indigoDecomposeMolecule(this.self, mol.self));
        if (res == 0) {
            return null;
        }
        return new IndigoObject(this.dispatcher, res, this);
    }

    public IndigoObject iterateDecompositions() {
        this.dispatcher.setSessionID();
        int res = Indigo.checkResult(this, this.lib.indigoIterateDecompositions(this.self));
        if (res == 0) {
            return null;
        }
        return new IndigoObject(this.dispatcher, res, this);
    }

    public void addDecomposition(IndigoObject q_match) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoAddDecomposition(this.self, q_match.self));
    }

    @Override
    public Iterator<IndigoObject> iterator() {
        return this;
    }

    @Override
    public void remove() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoRemove(this.self));
    }

    public void close() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoClose(this.self));
    }

    @Override
    public IndigoObject next() throws NoSuchElementException {
        this.dispatcher.setSessionID();
        int next = Indigo.checkResult(this, this.lib.indigoNext(this.self));
        if (next == 0) {
            throw new NoSuchElementException("iterator has ended");
        }
        return new IndigoObject(this.dispatcher, next, this);
    }

    @Override
    public boolean hasNext() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoHasNext(this.self)) == 1;
    }

    public int index() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoIndex(this.self));
    }

    public String toString() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this.lib.indigoToString(this.self));
    }

    public byte[] toBuffer() {
        PointerByReference ptr = new PointerByReference();
        IntByReference size = new IntByReference();
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoToBuffer(this.self, ptr, size));
        Pointer p = ptr.getValue();
        return p.getByteArray(0L, size.getValue());
    }

    public int[] symmetryClasses() {
        IntByReference count = new IntByReference();
        this.dispatcher.setSessionID();
        Pointer p = Indigo.checkResultPointer(this, this.lib.indigoSymmetryClasses(this.self, count));
        return p.getIntArray(0L, count.getValue());
    }

    public void append(IndigoObject obj) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, obj, this.lib.indigoAppend(this.self, obj.self));
    }

    public void optimize() {
        this.optimize(null);
    }

    public void optimize(String options) {
        if (options == null) {
            options = "";
        }
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoOptimize(this.self, options));
    }

    public boolean normalize() {
        return this.normalize(null);
    }

    public boolean normalize(String options) {
        if (options == null) {
            options = "";
        }
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoNormalize(this.self, options)) == 1;
    }

    public void standardize() {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoStandardize(this.self));
    }

    public void ionize(float pH, float pHToll) {
        this.dispatcher.setSessionID();
        Indigo.checkResult(this, this.lib.indigoIonize(this.self, pH, pHToll));
    }

    public float getAcidPkaValue(IndigoObject atom, int level, int min_level) {
        this.dispatcher.setSessionID();
        Pointer ptr = Indigo.checkResultPointer(this, this.lib.indigoGetAcidPkaValue(this.self, atom.self, level, min_level));
        return ptr.getFloat(0L);
    }

    public float getBasicPkaValue(IndigoObject atom, int level, int min_level) {
        this.dispatcher.setSessionID();
        Pointer ptr = Indigo.checkResultPointer(this, this.lib.indigoGetBasicPkaValue(this.self, atom.self, level, min_level));
        return ptr.getFloat(0L);
    }

    public int expandAbbreviations() {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoExpandAbbreviations(this.self));
    }

    public String dbgInternalType() {
        this.dispatcher.setSessionID();
        return Indigo.checkResultString(this, this.lib.indigoDbgInternalType(this.self));
    }

    public int copyRGroups(IndigoObject other) {
        this.dispatcher.setSessionID();
        return Indigo.checkResult(this, this.lib.indigoCopyRGroups(other.self, this.self));
    }
}

