/*
 * Decompiled with CFR 0.152.
 */
package com.epam.indigo;

import com.epam.indigo.Indigo;
import com.epam.indigo.IndigoInchiLib;
import com.epam.indigo.IndigoObject;
import com.epam.indigo.IndigoUtils;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.io.FileNotFoundException;

public class IndigoInchi {
    final Indigo indigo;
    static IndigoInchiLib lib;
    boolean initialized;

    public IndigoInchi(Indigo indigo) {
        IndigoInchi.loadLibrary(indigo.getUserSpecifiedPath());
        this.indigo = indigo;
        this.indigo.setSessionID();
        Indigo.checkResult(this, lib.indigoInchiInit(this.indigo.getSid()));
        this.initialized = true;
    }

    protected void finalize() throws Throwable {
        if (this.initialized) {
            this.indigo.setSessionID();
            Indigo.checkResult(this, lib.indigoInchiDispose(this.indigo.getSid()));
            super.finalize();
            this.initialized = false;
        }
    }

    public String version() {
        this.indigo.setSessionID();
        return Indigo.checkResultString(this, lib.indigoInchiVersion());
    }

    public void resetOptions() {
        this.indigo.setSessionID();
        Indigo.checkResult(this, lib.indigoInchiResetOptions());
    }

    public IndigoObject loadMolecule(String inchi) {
        this.indigo.setSessionID();
        return new IndigoObject(this.indigo, Indigo.checkResult(this, lib.indigoInchiLoadMolecule(inchi)));
    }

    public String getInchi(IndigoObject molecule) {
        this.indigo.setSessionID();
        return Indigo.checkResultString(this, lib.indigoInchiGetInchi(molecule.self));
    }

    public String getInchiKey(String inchi) {
        this.indigo.setSessionID();
        return Indigo.checkResultString(this, lib.indigoInchiGetInchiKey(inchi));
    }

    public String getWarning() {
        this.indigo.setSessionID();
        return Indigo.checkResultString(this, lib.indigoInchiGetWarning());
    }

    public String getLog() {
        this.indigo.setSessionID();
        return Indigo.checkResultString(this, lib.indigoInchiGetLog());
    }

    public String getAuxInfo() {
        this.indigo.setSessionID();
        return Indigo.checkResultString(this, lib.indigoInchiGetAuxInfo());
    }

    private static synchronized void loadLibrary(String path) {
        if (lib != null) {
            return;
        }
        try {
            if (Platform.isLinux() || Platform.isSolaris()) {
                lib = Native.load(IndigoUtils.getPathToBinary(IndigoInchi.class, Indigo.getPlatformDependentPath(), path, "libindigo-inchi.so"), IndigoInchiLib.class);
            } else if (Platform.isMac()) {
                lib = Native.load(IndigoUtils.getPathToBinary(IndigoInchi.class, Indigo.getPlatformDependentPath(), path, "libindigo-inchi.dylib"), IndigoInchiLib.class);
            } else if (Platform.isWindows()) {
                lib = Native.load(IndigoUtils.getPathToBinary(IndigoInchi.class, Indigo.getPlatformDependentPath(), path, "indigo-inchi.dll"), IndigoInchiLib.class);
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

