/*
 * Decompiled with CFR 0.152.
 */
package com.diqa.indigo.inchi;

import com.epam.indigo.Indigo;
import com.epam.indigo.IndigoInchi;
import com.epam.indigo.IndigoObject;
import java.io.File;

public class ConvertMolfileToInchIKey {
    public static void main(String[] args) {
        File file;
        if (args.length < 1) {
            System.err.println("Missing MOLFile parameter");
            System.exit(1);
        }
        if (!(file = new File(args[0])).exists()) {
            System.err.println("File '" + args[0] + "' does not exist.");
            System.exit(1);
        }
        Indigo indigo = new Indigo();
        indigo.setOption("molfile-saving-mode", "3000");
        IndigoObject molecule = indigo.loadMoleculeFromFile(file.getAbsolutePath());
        molecule.layout();
        IndigoInchi indigoInchi = new IndigoInchi(indigo);
        String inchi = indigoInchi.getInchi(molecule);
        String inchikey = indigoInchi.getInchiKey(inchi);
        System.out.println(inchikey);
    }
}

